% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_values.R
\name{driftPlot}
\alias{driftPlot}
\title{Plot the trend line for aggregated values}
\usage{
driftPlot(
  se,
  aggregation = c("median", "sum"),
  category = colnames(colData(se)),
  orderCategory = colnames(colData(se)),
  level = c("all", unique(colData(se)[, category])),
  method = c("loess", "lm")
)
}
\arguments{
\item{se}{\code{SummarizedExperiment}}

\item{aggregation}{\code{character}, type of aggregation of (count/intensity) 
values}

\item{category}{\code{character}, column of \code{colData(se)}}

\item{orderCategory}{\code{character}, column of \code{colData(se)}}

\item{level}{\code{character}, from which samples should the LOESS curve be
calculated, either \code{"all"} or one of the levels of the selected columns
of \code{colData(se)} (\code{"category"})}

\item{method}{\code{character}, either \code{"loess"} or \code{"lm"}}
}
\value{
\code{gg} object from \code{ggplot2}
}
\description{
The function \code{driftPlot} aggregates the (count/intensity) values from 
the \code{assay()} slot of a \code{SummarizedExperiment} by the \code{median} 
or \code{sum} of the (count/intensity) values. \code{driftPlot} then 
visualizes these aggregated values and adds a trend line (using either 
LOESS or a linear model) from (a subset of) the aggregated values. The 
subset is specified by the arguments \code{category} and \code{level}.
}
\details{
The x-values are sorted according to the \code{orderCategory} argument: The 
levels of the corresponding column in \code{colData(se)} are pasted with the 
sample names (in the column \code{name}) and factorized.
Internal usage in \code{shinyQC}.
}
\examples{
#' ## create se
set.seed(1)
a <- matrix(rnorm(1000), nrow = 10, ncol = 100, 
    dimnames = list(seq_len(10), paste("sample", seq_len(100))))
a[c(1, 5, 8), seq_len(5)] <- NA
cD <- data.frame(name = colnames(a), type = c(rep("1", 50), rep("2", 50)))
rD <- data.frame(spectra = rownames(a))
se <- SummarizedExperiment::SummarizedExperiment(assay = a, 
    rowData = rD, colData = cD)

driftPlot(se, aggregation = "sum", category = "type", 
    orderCategory = "type", level = "1", method = "loess")

}
