% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_values.R
\name{ECDF}
\alias{ECDF}
\title{Create ECDF plot of a sample against a reference}
\usage{
ECDF(se, sample = colnames(se), group = c("all", colnames(colData(se))))
}
\arguments{
\item{se}{\code{SummarizedExperiment} object}

\item{sample}{\code{character}, name of the sample to compare against the 
group}

\item{group}{\code{character}, either \code{"all"} or one of 
\code{colnames(colData(se))}}
}
\value{
\code{gg} object from \code{ggplot2}
}
\description{
The function \code{ECDF} creates a plot of the empirical cumulative 
distribution function of a specified sample and an outgroup (reference). 
The reference is specified by the \code{group} argument. The row-wise 
(feature) mean values of the reference are calculated after excluding 
the specified \code{sample}.
}
\details{
Internal use in \code{shinyQC}. 

The function \code{ECDF} uses the \code{ks.test} function from \code{stats} 
to perform a two-sample Kolmogorov-Smirnov test. The Kolmogorov-Smirnov 
test is run with the alternative \code{"two.sided"}
(null hypothesis is that the true distribution function of the 
\code{sample} is equal to the hypothesized distribution function of the 
\code{group}).

The \code{exact} argument in \code{ks.test} is set to \code{NULL}, meaning 
that an exact p-value is computed if the product of the sample sizes is 
less than 10000 of \code{sample} and \code{group}. Otherwise, asymptotic 
distributions are used whose approximations might be inaccurate in low 
sample sizes.
}
\examples{
## create se
set.seed(1)
a <- matrix(rnorm(1000), nrow = 100, ncol = 10, 
    dimnames = list(seq_len(100), paste("sample", seq_len(10))))
a[c(1, 5, 8), seq_len(5)] <- NA
cD <- data.frame(name = colnames(a), type = c(rep("1", 5), rep("2", 5)))
rD <- data.frame(spectra = rownames(a))
se <- SummarizedExperiment(assay = a, rowData = rD, colData = cD)

ECDF(se, sample = "sample 1", group = "all")

}
