% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_dataprocess_plots.R
\name{.makeQCPlot}
\alias{.makeQCPlot}
\title{Make QC plot}
\usage{
.makeQCPlot(
  input,
  all_proteins,
  y.limdown,
  y.limup,
  x.axis.size,
  y.axis.size,
  text.size,
  text.angle,
  legend.size,
  label.color,
  cumGroupAxis,
  groupName,
  lineNameAxis,
  yaxis.name
)
}
\arguments{
\item{input}{data.table}

\item{all_proteins}{character vector of protein names}

\item{x.axis.size}{size of x-axis labeling for "Run" in Profile Plot and 
QC Plot, and "Condition" in Condition Plot. Default is 10.}

\item{y.axis.size}{size of y-axis labels. Default is 10.}

\item{text.size}{size of labels represented each condition at the top of 
graph in Profile Plot and QC plot. Default is 4.}

\item{text.angle}{angle of labels represented each condition at the top
of graph in Profile Plot and QC plot or x-axis labeling in Condition plot. 
Default is 0.}

\item{legend.size}{size of feature legend (transition-level or peptide-level)
above graph in Profile Plot. Default is 7.}
}
\description{
To illustrate the quantitative data after data-preprocessing and 
quality control of MS runs, dataProcessPlots takes the quantitative data from 
function (\code{\link{dataProcess}}) as input and automatically generate 
three types of figures in pdf files as output : 
(1) profile plot (specify "ProfilePlot" in option type), 
to identify the potential sources of variation for each protein; 
(2) quality control plot (specify "QCPlot" in option type), 
to evaluate the systematic bias between MS runs; 
(3) mean plot for conditions (specify "ConditionPlot" in option type), 
to illustrate mean and variability of each condition per protein.
}
\details{
\itemize{
\item{Profile Plot : identify the potential sources of variation of each protein. QuantData$FeatureLevelData is used for plots. X-axis is run. Y-axis is log-intensities of transitions. Reference/endogenous signals are in the left/right panel. Line colors indicate peptides and line types indicate transitions. In summarization plots, gray dots and lines are the same as original profile plots with QuantData$FeatureLevelData. Dark dots and lines are for summarized intensities from QuantData$ProteinLevelData.}
\item{QC Plot : illustrate the systematic bias between MS runs. After normalization, the reference signals for all proteins should be stable across MS runs. QuantData$FeatureLevelData is used for plots. X-axis is run. Y-axis is log-intensities of transition. Reference/endogenous signals are in the left/right panel. The pdf file contains (1) QC plot for all proteins and (2) QC plots for each protein separately.}
\item{Condition Plot : illustrate the systematic difference between conditions. Summarized intensnties from QuantData$ProteinLevelData are used for plots. X-axis is condition. Y-axis is summarized log transformed intensity. If scale is TRUE, the levels of conditions is scaled according to its actual values at x-axis. Red points indicate the mean for each condition. If interval is "CI", blue error bars indicate the confidence interval with 0.95 significant level for each condition. If interval is "SD", blue error bars indicate the standard deviation for each condition.The interval is not related with model-based analysis.}
}
The input of this function is the quantitative data from function \code{\link{dataProcess}}.
}
\examples{
# Consider quantitative data (i.e. QuantData) from a yeast study with ten time points of interests, 
# three biological replicates, and no technical replicates which is a time-course experiment. 
# The goal is to provide pre-analysis visualization by automatically generate two types of figures 
# in two separate pdf files. 
# Protein IDHC (gene name IDP2) is differentially expressed in time point 1 and time point 7, 
# whereas, Protein PMG2 (gene name GPM2) is not.

QuantData<-dataProcess(SRMRawData, use_log_file = FALSE)
head(QuantData$FeatureLevelData)
# Profile plot
dataProcessPlots(data=QuantData,type="ProfilePlot")
# Quality control plot 
dataProcessPlots(data=QuantData,type="QCPlot")	
# Quantification plot for conditions
dataProcessPlots(data=QuantData,type="ConditionPlot")

}
\keyword{internal}
