% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-addIdentificationData.R
\name{filterIdentificationDataFrame}
\alias{filterIdentificationDataFrame}
\title{Filter out unreliable PSMs.}
\usage{
filterIdentificationDataFrame(
  x,
  decoy = "isDecoy",
  rank = "rank",
  accession = "DatabaseAccess",
  spectrumID = "spectrumID",
  verbose = isMSnbaseVerbose()
)
}
\arguments{
\item{x}{A \code{data.frame} containing PSMs.}

\item{decoy}{The column name defining whether entries match the
decoy database. Default is \code{"isDecoy"}. The column should be a
\code{logical} and only PSMs holding a \code{FALSE} are
retained. Ignored is set to \code{NULL}.}

\item{rank}{The column name holding the rank of the PSM. Default
is \code{"rank"}. This column should be a \code{numeric} and only PSMs
having rank equal to 1 are retained. Ignored is set to \code{NULL}.}

\item{accession}{The column name holding the protein (groups)
accession. Default is \code{"DatabaseAccess"}. Ignored is set to
\code{NULL}.}

\item{spectrumID}{The name of the spectrum identifier
column. Default is \code{spectrumID}.}

\item{verbose}{A \code{logical} verbosity flag. Default is to take
\code{isMSnbaseVerbose()}.}
}
\value{
A new \code{data.frame} with filtered out peptides and with the
same columns as the input \code{x}.
}
\description{
A function to filter out PSMs matching to the decoy database, of
rank greater than one and matching non-proteotypic peptides.
}
\details{
The PSMs should be stored in a \code{data.frame} such as those produced
by \code{\link[=readMzIdData]{readMzIdData()}}. Note that this function should be called
before calling the \link[=reduce,data.frame-method]{reduce} method on a
PSM \code{data.frame}.
}
\author{
Laurent Gatto
}
