% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cds2codonaln.R
\name{cds2codonaln}
\alias{cds2codonaln}
\title{cds2codonaln}
\usage{
cds2codonaln(
  cds1,
  cds2,
  type = "global",
  substitutionMatrix = "BLOSUM62",
  gapOpening = 10,
  gapExtension = 0.5,
  remove.gaps = FALSE,
  ...
)
}
\arguments{
\item{cds1}{single sequence \code{DNAStringSet} or \code{DNAString}
[mandatory]}

\item{cds2}{single sequence \code{DNAStringSet} or \code{DNAString}
[mandatory]}

\item{type}{type of alignment (see
\code{\link[pwalign]{pairwiseAlignment}}) [default: global]}

\item{substitutionMatrix}{substitution matrix representing the fixed
substitution scores for an alignment (see
\code{\link[pwalign]{pairwiseAlignment}}) [default: BLOSUM62]}

\item{gapOpening}{the cost for opening a gap in the alignment (see
\code{\link[pwalign]{pairwiseAlignment}}) [default: 10]}

\item{gapExtension}{the incremental cost incurred along the length of the
gap in the alignment (see \code{\link[pwalign]{pairwiseAlignment}})
[default: 0.5]}

\item{remove.gaps}{specify if gaps in the codon alignment should be removed
[default: FALSE]}

\item{...}{other cds2aa parameters}
}
\value{
codon alignment as \code{DNAStringSet}
}
\description{
This function takes two single sequence \code{DNAString}'s or
two single sequence \code{DNAStringSet}'s, converts them into aa, calculates
a global alignment and converts this alignment back into a codon alignment.
}
\examples{
## define two cds sequences
cds1 <- Biostrings::DNAString("ATGCAACATTGC")
cds2 <- Biostrings::DNAString("ATGCATTGC")
cds2codonaln(cds1, cds2)
}
\references{
Pagès, H et al. (2014) Biostrings: Efficient manipulation of
biological strings. \emph{R package version}, \bold{2(0)}.
}
\seealso{
\code{\link[pwalign]{pairwiseAlignment}}
}
\author{
Kristian K Ullrich
}
