% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelSelection.R
\name{setModel}
\alias{setModel}
\title{Set the distributional model used. Default is gamma.pois, and is recommended.
Other supoprted models are ln.nb in which the DNA follows a log-normal
distribution and the RNA follows a negative binomial, and ln.ln in which
both follow log-normal distributions.
To use alternative distributional models, use this function before fitting
the model.}
\usage{
setModel(obj, model)
}
\arguments{
\item{obj}{the MPRAnalyze object}

\item{model}{the charater identifier of the model to be used. Currently 
supported models: "ln.nb", "gamma.pois", "ln.ln"}
}
\value{
the MPRAnalyze with the model set for the given value
}
\description{
Set the distributional model used. Default is gamma.pois, and is recommended.
Other supoprted models are ln.nb in which the DNA follows a log-normal
distribution and the RNA follows a negative binomial, and ln.ln in which
both follow log-normal distributions.
To use alternative distributional models, use this function before fitting
the model.
}
\examples{
data <- simulateMPRA(tr = rep(2,10), da=NULL, nbatch=2, nbc=20)
obj <- MpraObject(dnaCounts = data$obs.dna, 
                  rnaCounts = data$obs.rna, 
                  colAnnot = data$annot)
obj <- estimateDepthFactors(obj, lib.factor = "batch", which.lib = "both")
obj <- setModel(obj, "ln.ln")
obj <- analyzeQuantification(obj, dnaDesign = ~ batch + barcode, 
                              rnaDesign = ~1)
}
