% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pltOvrHm.R
\name{pltOvrHm}
\alias{pltOvrHm}
\title{Plot a heatmap of over-represented gene sets for clustered samples}
\usage{
pltOvrHm(ovrmat, cldt, min_frc = 0.8)
}
\arguments{
\item{ovrmat}{A matrix containing over-representation adjusted P with
rows as gene set names and columns as sample IDs. It is the
output of the \code{ovrGMT()} function.}

\item{cldt}{A data table with each row representing one clustering
result, and the first column denotes the number of
occurrences of a clustering result and the rest of columns
indicating each sample's cluster index. It is the output
of the \code{clSamp()} function. Only the most frequent
clustering result will be used to plot.}

\item{min_frc}{A minimum fraction of samples in a cluster that have a gene
set significantly over-represented (adjusted P < 0.05).
This is used to select gene sets to plot. Default: 0.8}
}
\value{
A heatmap with rows as over-represented gene sets and columns as
samples splited by clusters.
}
\description{
Plot a heatmap of over-represented gene sets for clustered samples
}
\examples{

ovrmat <- system.file('extdata/pltOvrHm/ovr.rds',package='MPAC') |> readRDS()
cldt   <- system.file('extdata/pltOvrHm/cl.rds', package='MPAC') |> readRDS()

pltOvrHm(ovrmat, cldt)

}
