% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_coexpression.R
\name{match_gene_regulator_cluster}
\alias{match_gene_regulator_cluster}
\title{match_gene_regulator_cluster}
\usage{
match_gene_regulator_cluster(rna, atac, cell_types, associationMatrix)
}
\arguments{
\item{rna}{rna expression dataframe}

\item{atac}{atac expression dataframe}

\item{cell_types}{list of which cells belong to each celltype}

\item{associationMatrix}{matrix of related genes and peaks}
}
\description{
match_gene_regulator_cluster
}
\examples{
rna <- data.frame(c1 = c(1.5, 15.5, 3.5, 20.5), c2 = c(2, 15, 4, 20), 
        c3 = c(10, 1, 12, 13), c4 = c(11, 1, 13, 14), c5 = c(7, 0, 0, 0), 
        c6 = c(8, 1, 1, 1), c7 = c(8, 1, 1, 1))
rownames(rna) <- c('GenB', 'GenA', 'GenC', 'GenD')
associationList <- data.frame(Gene_ID = c('GenA', 'GenB', 'GenC', 'GenA'),
        Peak_ID = c('PeakA', 'PeakB', 'PeakC', 'PeakD'),
        Gene_cluster = c(1, 2, 1, 2), Peak_cluster = c(1, 2, 1, 2))
cell_types <- list("ct1" = c(1,2), "ct2" = c(3, 4), "ct3" = c(5, 6), "ct4" = c(7))
atac <- data.frame(c1 = c(3,20, 1,15, 1, 7, 1), c2 = c(4,20, 2,15, 0, 5, 1.5), 
        c3 = c(10, 13, 1, 12, 1, 14, 9), c4 = c(11, 14, 1, 13, 1, 4, 12), 
        c5 = c(0, 0, 0, 7, 1, 6, 6), c6 = c(1, 1, 1, 8, 0, 5, 8), 
        c7 = c(1, 1, 1, 8, 1, 5, 7))
rownames(atac) <- c('PeakB', "PeakC", "PeakF", "PeakD", "PeakE", "PeakA", "PeakG")
match_gene_regulator_cluster(rna, atac, cell_types, associationList)
}
