% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODA.R
\name{WeightedModulePartitionAmoutain}
\alias{WeightedModulePartitionAmoutain}
\title{Modules detection by AMOUNTAIN algorithm}
\usage{
WeightedModulePartitionAmoutain(datExpr, Nmodule, foldername, indicatename,
  GeneNames, maxsize = 200, minsize = 3, power = 6, tao = 0.2)
}
\arguments{
\item{datExpr}{gene expression profile, rows are samples and columns genes}

\item{Nmodule}{the number of clusters(modules)}

\item{foldername}{where to store the clusters}

\item{indicatename}{normally a specific tag of condition}

\item{GeneNames}{normally the gene official names to replace the colnames of datExpr}

\item{maxsize}{the maximal nodes allowed in one module}

\item{minsize}{the minimal nodes allowed in one module}

\item{power}{the power parameter of WGCNA, W_{ij}=|cor(x_i,x_j)|^pwr}

\item{tao}{the threshold to cut the adjacency matrix}
}
\value{
None
}
\description{
Module detection based on the AMOUNTAIN algorithm, which tries to find the  
optimal module every time and use a modules extraction way
}
\examples{
data(synthetic)
ResultFolder <- 'ForSynthetic' # where middle files are stored
GeneNames <- colnames(datExpr1)
intModules1 <- WeightedModulePartitionAmoutain(datExpr1,5,ResultFolder,'X',
GeneNames,maxsize=100,minsize=50)
truemodule <- c(rep(1,100),rep(2,100),rep(3,100),rep(4,100),rep(5,100))
#mymodule <- getPartition(ResultFolder)
#randIndex(table(mymodule,truemodule),adjust=F)
}
\author{
Dong Li, \email{dxl466@cs.bham.ac.uk}
}
\references{
Blondel, Vincent D., et al. "Fast unfolding of communities in 
large networks." Journal of statistical mechanics: theory and experiment 
2008.10 (2008): P10008.
}
\keyword{optimization}

