% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGeneSets.R
\name{getGeneSets}
\alias{getGeneSets}
\title{Prepare Pathway Data for the MLP Function}
\usage{
getGeneSets(species = "Mouse", geneSetSource = NULL, entrezIdentifiers)
}
\arguments{
\item{species}{character vector of length one indicating the species, one of
'Mouse', 'Human', 'Rat', 'Dog' or 'Rhesus'; defaults to 'Mouse'.}

\item{geneSetSource}{source to be used to construct the list of pathway categories; 
for public data sources, the user can specify a string (one of 'GOBP', 'GOMF', 'GOCC', 'KEGG' or 'REACTOME')
and BioC packages will be used to construct the list of pathway categories; 
for non-public data sources, the user can pass the pathway data as a dataframe with (at least) 
the following four columns: PATHWAYID, TAXID, PATHWAYNAME and GENEID. It is assumed all columns
are of type character.}

\item{entrezIdentifiers}{Entrez Gene identifiers used to subset the relevant gene set}
}
\value{
object of class geneSetMLP which is essentially a named 
list of pathway categories. \cr
Each list component is named with the pathway ID and 
contains a vector of Entrez Gene identifiers 
related to that particular pathway.\cr
The object contains additionally the attributes:
\itemize{
\item 'species' and 'geneSetSource': \code{species} and \code{geneSetSource}
(as provided as input)
\item 'descriptions': named character vector with pathway descriptions.
The vector is named with the pathway ID.
}
}
\description{
The return value of the getGeneSets function has as primary use
to serve as geneSet argument for the MLP function
}
\examples{
if (require(GO.db) && require(org.Mm.eg.db)){
  pathExamplePValues <- system.file("exampleFiles", "examplePValues.rda", package = "MLP")
  load(pathExamplePValues)
  geneSet <- getGeneSets(species = "Mouse", geneSetSource = "GOBP", entrezIdentifiers = names(examplePValues)[seq_len(2000)])
	 geneSet <- getGeneSets(species = "Mouse", geneSetSource = "KEGG", entrezIdentifiers = names(examplePValues)[seq_len(2000)])
}
}
