% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{enrichedFeatures}
\alias{enrichedFeatures}
\title{Extract the names of the pre-ranked features in a GSEA experiment}
\usage{
enrichedFeatures(object)
}
\arguments{
\item{object}{An object of class
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}} containing
enrichment results}
}
\value{
A \code{character} vector with the names of the genes ordered based on the
ranking metric.
}
\description{
This function accesses the \code{features} slot of a
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}} object and returns
a \code{character} vector with the names of the features considered in GSEA in
the same order as the ranking metric.
}
\examples{
# load example FunctionalEnrichment object
obj <- loadExamples("FunctionalEnrichment")

# extract the ranking metric
rmet <- enrichmentMetric(obj)

## extract the corresponding names
rnames <- enrichedFeatures(obj)

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
