% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{integrationDatabase}
\alias{integrationDatabase}
\title{Extract the database used for integrative miRNA-mRNA pathway analyses}
\usage{
integrationDatabase(object)
}
\arguments{
\item{object}{An object of class
\code{\link[=IntegrativePathwayAnalysis-class]{IntegrativePathwayAnalysis}} containing
the results of a miRNA-mRNA pathway analysis}
}
\value{
A \code{character} object with the name of the database used by the
\code{\link[=topologicalAnalysis]{topologicalAnalysis()}} function, such as \code{KEGG}.
}
\description{
This function accesses the \code{database} slot of a
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}} object and returns
the name of the database used by the \code{\link[=topologicalAnalysis]{topologicalAnalysis()}} function to
perform the integrative topological analysis.
}
\examples{
# load the example IntegrativePathwayAnalysis object
obj <- loadExamples("IntegrativePathwayAnalysis")

# see the database
integrationDatabase(obj)

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
