% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIRA.R
\name{BSreadBiSeq}
\alias{BSreadBiSeq}
\title{Read in files from biseq meth caller}
\usage{
BSreadBiSeq(files, contrastList = NULL, cores = 4,
  returnAsList = FALSE)
}
\arguments{
\item{files}{a vector of file paths}

\item{contrastList}{Generally not needed for MIRA. 
A list of named character vectors, 
each with length equal to the number of items in files. 
These will translate into column names in the final table.}

\item{cores}{number of processors.}

\item{returnAsList}{Whether to return the output as a list 
or as one big data.table.}
}
\value{
Data from each input file joined together into one big data.table.
If returnAsList = TRUE, then input from each file will be 
in its own data.table in a list.
}
\description{
Parses the x/y format of methylation calls, 
splitting them into individual columns: "methylCount" column for
number of methylated reads for site and "coverage" column for total
number of reads covering that site. Input files should have the following
columns: "chr", "start", "end", "meth", "rate", "strand".
}
\details{
This can run into memory problems if there are too many files...
because of the way parallel lacks long vector support. The solution is
to just use a single core; or to pass mc.preschedule = FALSE; This
makes it so that each file is processed as a separate job. Much better.
}
\examples{
shortBSDTFile <- system.file("extdata", "shortRRBS.bed", package = "MIRA") 
shortBSDT <- BSreadBiSeq(shortBSDTFile)

}
