% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVPlot.R
\name{CVPlot}
\alias{CVPlot}
\title{Make correlation vector plot}
\usage{
CVPlot(cv.df, geneset.loc, geneset.name, alpha1 = 0.005, alpha2 = 0.1,
  cnames = NULL)
}
\arguments{
\item{cv.df}{A dataframe containing the correlation vectors of one or more patterns.}

\item{geneset.loc}{A gene set of interest (e.g. mitochondrial) to be plotted separately from rest of genes.}

\item{geneset.name}{Name of geneset (e.g. mitochondrial genes)}

\item{alpha1}{Transparency level of non-gene set genes}

\item{alpha2}{Transparency level of gene set genes}

\item{cnames}{Character vector containing names for the correlation vector}
}
\value{
A plot of the correlation vectors
}
\description{
A function to visualise the differences between different found biclusters. 
Output is a matrix of plots. Each correlation vector is plotted against each 
other across the entire  measured gene set in the lower diagonal plots, and
a chosen gene set (e.g. mitochondrial) in the upper diagonal plots. The diagnal
plots themselves show the density plots of the entire measured and chosen
gene set. There are addition options to set the transparancy of the data
points and names of the correlation vectors.
}
\examples{
data(CCLE_small)
data(Mitochondrial_genes)

mito.loc <- which(row.names(CCLE_small) \%in\% Mitochondrial_genes)
CCLE.mito <- CCLE_small[mito.loc,]

CCLE.seed <- list()
CCLE.cor.vec <- list()

for(i in 1:3){
    set.seed(i)
    CCLE.seed[[i]] <- FindSeed(gem = CCLE.mito,
                               seed.size = 10,
                               iterations = 100,
                               messages = 100)}

for(i in 1:3){
    CCLE.cor.vec[[i]] <-  CVEval(gem.part = CCLE.mito,
                                 gem.all = CCLE_small,
                                 seed = CCLE.seed[[i]],
                                splits = 10)}



CCLE.cor.df <- (as.data.frame(CCLE.cor.vec))

CVPlot(cv.df = CCLE.cor.df, geneset.loc = mito.loc,
       geneset.name = "Mitochondrial",alpha1 = 0.5)
}
