% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbqnPlotRI.R
\name{mbqnPlotRI}
\alias{mbqnPlotRI}
\title{Plot frequency of detected RI/NRI features}
\usage{
mbqnPlotRI(obj, verbose = FALSE, ...)
}
\arguments{
\item{obj}{list object of RI frequencies from \code{mbqnGetNRIfeatures()}.}

\item{verbose}{logical indicating to run function quietly.}

\item{...}{additional arguments (cex, cex.lab, cex.axis, cex.main) passed to
the plot function.}
}
\value{
Figure
}
\description{
Plot rank invariance frequency and feature coverage of detected
RI and NRI features
}
\details{
Graphical output of the NRI/RI identification results from
\code{mbqnGetNRIfeatures()}. For each detected NRI/RI feature, plot the
feature index against the RI frequencies together with the RI frequency
detection threshold and print the sample coverage.
}
\examples{
## Check data matrix for RI and NRI features
x <- mbqnSimuData("omics.dep")
RI <- mbqnGetNRIfeatures(x, low_thr = 0.5, verbose = FALSE)
mbqnPlotRI(RI)
}
\references{
Brombacher, E., Schad, A., Kreutz, C. (2020). Tail-Robust
Quantile Normalization. BioRxiv.
}
\seealso{
\code{\link[=mbqnGetNRIfeatures]{mbqnGetNRIfeatures()}} for detection of NRI/RI features.
}
\author{
Ariane Schad
}
