% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_analyses.R
\name{mbecMosaic}
\alias{mbecMosaic}
\title{Mosaic Sample Group Allocation}
\usage{
mbecMosaic(input.obj, model.vars = c("batch", "group"), return.data = FALSE)
}
\arguments{
\item{input.obj}{MbecData object}

\item{model.vars}{Two covariates of interest to the sample allocation.}

\item{return.data}{Logical if TRUE returns the data.frame required for
plotting. Default (FALSE) will return plot object.}
}
\value{
either a ggplot2 object or a formatted data-frame to plot from
}
\description{
Depicts the dispersion of samples over two (preferentially categorical)
covariates of interest. Effectively showing, the un-/evenness within and
between covariates to inform the choice of methods for the subsequent steps
in an analysis.
}
\details{
The function returns either a plot-frame or the finished ggplot object. Input
for the data-set can be an MbecData-object.
}
\examples{
# This will return the plot-df of the samples grouped by group and batch.
data(dummy.mbec)
data.Mosaic <- mbecMosaic(input.obj=dummy.mbec,
model.vars=c('group','batch'), return.data=TRUE)

# Return the ggplot2 object of the samples grouped by group and batch
plot.Mosaic <- mbecMosaic(input.obj=dummy.mbec,
model.vars=c('group','batch'), return.data=FALSE)
}
\keyword{Mosaic}
\keyword{allocation}
\keyword{sample}
