% Generated by roxygen2 (4.0.1): do not edit by hand
\name{vectorizedRbetabinomAB}
\alias{vectorizedRbetabinomAB}
\alias{vectorizedRbetabinomMR}
\title{Functions to generate beta-binomial random variables.}
\usage{
vectorizedRbetabinomAB(n, size, a, b, checkArgs = FALSE)

vectorizedRbetabinomMR(n, size, mu, rho, checkArgs = FALSE)
}
\arguments{
\item{n}{sample size, must be a single positive integer}

\item{size}{number of trials for each count to be generated in the sample, must be a vector of positive integers}

\item{a,b}{vectors of shape parameters for beta distributions used to generate probability of success for each count to be generated in the sample, must be >0}

\item{checkArgs}{single boolean specifying whether arguments should be checked for adherence to specifications. DEFAULT: FALSE}

\item{mu,rho}{mean (a/(a+b)) and dispersion (1/(a+b+1)) parameters for beta distribution, must be in (0,1). Value of 0 is allowed for rho and implies binomial distribution.}
}
\value{
a numeric vector of betabinomial random variables.
}
\description{
Functions to generate beta-binomial random variables.


}
\details{
vectorizedRbetabinomAB is the same function as rbetabinom.ab from VGAM package but it avoids a lot of overhang and requires that arguments size, a (shape1), and b (shape2) be of length equal to argument n.

vectorizedRbetabinomMR is a wrapper around vectorizedRbetabinomAB using mu/rho parametrization.  Requires that arguments size, mu, and rho be of length equal to argument n.
}
\examples{
set.seed(111)
MBASED:::vectorizedRbetabinomAB(n=10, size=rep(50,10), a=rep(1,10), b=rep(1,10))
set.seed(111)
MBASED:::vectorizedRbetabinomMR(n=10, size=rep(50,10), mu=rep(1/2,10), rho=rep(1/3,10))
}
\seealso{
Other bbFunctions: \code{\link{getAB}},
  \code{\link{getAB}}, \code{\link{getMuRho}}

Other bbFunctions: \code{\link{getAB}},
  \code{\link{getAB}}, \code{\link{getMuRho}}
}

