% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSEA-by-boot.R
\name{summary,GSEATests-method}
\alias{summary,GSEATests-method}
\title{Summarize gene set enrichment tests}
\usage{
\S4method{summary}{GSEATests}(object, ...)
}
\arguments{
\item{object}{A \code{GSEATests} object}

\item{...}{passed to \code{calcZ}}
}
\value{
\code{data.table}
}
\description{
Returns a \code{data.table} with one row per gene set.
This \code{data.table} contains columns: 
\describe{
  \item{set}{name of gene set}
  \item{cond_Z}{Z statistic for continuous component}
\item{cont_P}{wald P value}
\item{cont_effect}{difference in continuous regression coefficients between null and test sets (ie, the numerator of the Z-statistic.)}
\item{disc_Z}{Z statistic for discrete}
\item{disc_P}{wald P value}
\item{disc_effect}{difference in discrete regression coefficients between null and test sets.}
\item{combined_Z}{combined discrete and continuous Z statistic using Stouffer's method}
\item{combined_P}{combined P value}
\item{combined_adj}{FDR adjusted combined P value}
}
}
\examples{
## See the examples in gseaAfterBoot
example(gseaAfterBoot)
}
\seealso{
gseaAfterBoot
}
