% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpretation.R
\name{qtlTFBSMotifEnrichment}
\alias{qtlTFBSMotifEnrichment}
\title{qtlTFBSMotifEnrichment}
\usage{
qtlTFBSMotifEnrichment(
  meth.qtl.res,
  type = "SNP",
  size = 500,
  assembly = "hg19",
  subsample = 1e+05,
  out.dir = getwd(),
  ...
)
}
\arguments{
\item{meth.qtl.res}{An object of type \code{\link{MethQTLResult-class}} or a list of such objects}

\item{type}{The type of methQTL to be visualized. Can be either \code{'SNP'}, \code{'CpG'},
or \code{'cor.block'}}

\item{size}{Motif enrichment is only supported for genomic regions. Therefore, we resize the invididual methQTL to
genomic regions using a width of this size around the site of interest.}

\item{assembly}{The assembly used. Only \code{"hg19"} and \code{"hg38"} supported}

\item{subsample}{Integer specifying how many of the regions are to be subsamples from the universe.}

\item{out.dir}{The output directory in which resulting plots will be stored.}

\item{...}{Further parameters passed to \code{findMotifFgBg}}
}
\value{
A plot describing the TFB motif enrichment
}
\description{
This function performs TFBS enrichment analysis for the methQTL SNPs/CpGs detected and returns overrepresented
binding motifs.
}
\details{
This function is in part based on the tutorial for Motif discovery in https://compgenomr.github.io/book/motif-discovery.html.
We use all data points that have been used to calculate methQTLs as the background
and compare the overlaps with the annotation of interest in comparison to the methQTLs that
have been computed in case a \code{\link{MethQTLResult-class}} is provided. If a list of \code{\link{MethQTLResult-class}} objects
is provided, the intersection between the methQTLs from all objects in the list is compared with the union of all interactions
that have been tested.
}
\examples{
meth.qtl.res <- loadMethQTLResult(system.file("extdata","MethQTLResult_chr18",package="MAGAR"))
res <- qtlTFBSMotifEnrichment(meth.qtl.res)
}
\author{
Michael Scherer
}
