% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dAB.R
\name{dAB}
\alias{dAB}
\title{dAB}
\usage{
dAB(x, Data, adjust.methods = "BH", threshold = 0.05)
}
\arguments{
\item{x}{is an object of DistStatis Class.}

\item{Data}{should be the same imput list than in LinkData object.
If you integrated microbial communities and other types of data,
please be careful: choose only the microbial communities as input to dab object!!!!}

\item{adjust.methods}{character, correction method.
Choose one between:  c('holm', 'hochberg', 'hommel', 'bonferroni', 'BH', 'BY',
 'fdr', 'none').}

\item{threshold}{fixed pre-defined threshold value, which is
referred to as the level of significance.}
}
\value{
Diferentialb: a list with selected OTUs and their p-values.
}
\description{
Function to estimate differential abundance (if nCluster in
LinkData function is at least 2). The function uses a
non parametric kruskal-wallis test follow up by corrected p-values.
The function is robust since it doesn't assume normality on data distribution.
This function calculates the differential abundance (at OTU level)
betweeen all the communities data
It is only used when CLusters (enterotypes-like) is activated in LinkData function.
The function takes into account the
compositional nature of the OTUs dataset.
The differential expression is an alternative way to perform variable selection
}
\examples{
{
data(Taraoceans)
pro.phylo <- Taraoceans$taxonomy[ ,'Phylum']
TaraOc<-list(Taraoceans$phychem,
as.data.frame(Taraoceans$pro.phylo),as.data.frame(Taraoceans$pro.NOGs))
TaraOc_1<-scale(TaraOc[[1]])
Normalization<-lapply(list(TaraOc[[2]],TaraOc[[3]]),
function(x){DataProcessing(x,Method='Compositional')})
colnames(Normalization[[1]])=pro.phylo
colnames(Normalization[[2]])=Taraoceans$GO
TaraOc<-list(TaraOc_1,Normalization[[1]],Normalization[[2]])
names(TaraOc)<-c('phychem','pro_phylo','pro_NOGs')
TaraOc<-lapply(TaraOc,as.data.frame)
Output<-LinkData(TaraOc,Scale =FALSE,Distance =
c('ScalarProduct','Euclidean','Euclidean'),nCluster=3)
dAB(Output,Data=list(TaraOc[[2]]))
}

}
\references{
{
\enumerate{
\item
\item Kruskal, W. H., & Wallis, W. A. (1952). Use of ranks in one-criterion variance analysis.
Journal of the American statistical Association, 47(260), 583-621.
\item Benjamini, Y., and Hochberg, Y. (1995). Controlling the false discovery rate: a practical
and powerful approach to multiple testing.
 Journal of the Royal Statistical Society Series B 57, 289–300.
\item Wright, S. P. (1992). Adjusted P-values for simultaneous inference.
Biometrics 48, 1005–1013. (Explains the adjusted P-value approach.)
}
}
}
\author{
Laura M Zingatetti
}
