% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LACEinterface.R
\name{LACEview}
\alias{LACEview}
\title{LACE Processing and Analysis Interface}
\usage{
LACEview()
}
\value{
The GUI
}
\description{
\code{LACEview} displays a Shiny user interface to
handle the VCF and BAM files processing that is needed to
construct the input for the LACE inference algorithms.
The function generates also the maximum likelihood longitudinal
clonal tree, and shows the output for further explorations of
the results.
}
\note{
The function \code{LACE} is still available for retrocompatibility.
}
\section{Installation}{

The package is available on GitHub and Bioconductor.
LACE 2.0 requires R > 4.1.0 and Bioconductor.

To install directly from github run:

\if{html}{\out{<div class="sourceCode">}}\preformatted{remotes::install_github("https://github.com/BIMIB-DISCo/LACE", 
                        dependencies = TRUE)
}\if{html}{\out{</div>}}
}

\section{Dependencies}{

LACE 2.0 uses \emph{Annovar} and \emph{Samtools suite} as back-ends for variant calling
annotation and depth computation, respectively.

\emph{Annovar} is a variant calling software written in \emph{Perl} freely available upon
registration to their website at
\url{https://annovar.openbioinformatics.org/en/latest/}.

\emph{Perl} can be found and installed at \url{https://www.perl.org/}.

\emph{Samtools suite} is a set of tools to handle SAM/BAM/BED file format. It is
freely available at \url{http://www.htslib.org/}. To install \emph{Samtools} follow the
instructions in their website.
}

