% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataPlot.R
\name{dataPlot}
\alias{dataPlot}
\title{Plot different graphs depending on the current step of KnowSeq pipeline.}
\usage{
dataPlot(
  data,
  labels,
  colours = c("red", "green"),
  main = "",
  ylab = "Expression",
  xlab = "Samples",
  xgrid = FALSE,
  ygrid = FALSE,
  legend = "",
  mode = "boxplot",
  heatmapResultsN = 0,
  toPNG = FALSE,
  toPDF = FALSE
)
}
\arguments{
\item{data}{Normally, the data parameter is an expression matrix or data.frame, however for the confusionMatrix plot, the data are a confussion matrix that can be achieved by using the output of any of the machine learning functions of this package.}

\item{labels}{A vector or factor that contains the labels for each of the samples in the data parameter.}

\item{colours}{A vector that contains the desired colours to plot the different charts. Example: c("red","green","blue").}

\item{main}{The title for the plot.}

\item{ylab}{The description for the y axis.}

\item{xlab}{The description for the x axis.}

\item{xgrid}{Shows the x grid into the plot}

\item{ygrid}{Shows the y grid into the plot}

\item{legend}{A vector with the elements in the legend of the plot.}

\item{mode}{The different plots supported by this package. The possibilities are boxplot, orderedBoxplot, genesBoxplot, heatmap, confusionMatrix, classResults and heatmapResults.}

\item{heatmapResultsN}{Number of genes to show when mode is equal to heatmapResults.}

\item{toPNG}{Boolean variable to indicate if a plot would be save to PNG.}

\item{toPDF}{Boolean variable to indicate if a plot would be save to PDF.}
}
\value{
Nothing to return.
}
\description{
This function allows to plot different charts only by changing the parameters, for the different KnowSeq pipeline steps. Furthermore, the chosen plot can be saved to PNG and PDF.
}
\examples{
dir <- system.file("extdata", package="KnowSeq")
load(paste(dir,"/expressionExample.RData",sep = ""))

dataPlot(expressionMatrix,labels,mode = "boxplot",toPNG = TRUE,toPDF = TRUE)
dataPlot(DEGsMatrix[1:12,],labels,mode = "orderedBoxplot",toPNG = TRUE,toPDF = TRUE)
dataPlot(DEGsMatrix[1:12,],labels,mode = "genesBoxplot",toPNG = TRUE,toPDF = FALSE)
dataPlot(DEGsMatrix[1:12,],labels,mode = "heatmap",toPNG = TRUE,toPDF = TRUE)

results <- knn_trn(t(DEGsMatrix), labels, rownames(DEGsMatrix), 3)
dataPlot(results, labels = "", mode = "heatmapResults", main = "Plot to show indicators of trained model")
}
