% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap_info.R
\name{overlap_info}
\alias{overlap_info}
\title{Get overlap information for pairs of gene knock-outs from LINCS data}
\usage{
overlap_info(KGML_file, KEGG_mappings, cell_type, data_type = "100_full",
  pert_time = 96, only_mapped = TRUE, affy_based = FALSE,
  keep_counts_only = TRUE, add_fisher_information = TRUE,
  p.adjust.method = "BH")
}
\arguments{
\item{KGML_file}{An object of formal class KEGGPathway}

\item{KEGG_mappings}{The data.frame object generated by the function 
expand_KEGG_mappings}

\item{cell_type}{Choose from the set of cell lines: 
(A375,A549,ASC,HA1E,HCC515,HEK293T,HEKTE,HEPG2,HT29,MCF7,NCIH716,NPC,PC3,
SHSY5Y,SKL,SW480,VCAP)}

\item{data_type}{Choose from data types: (100_full, 100_bing, 50_lm)}

\item{pert_time}{Choose from (6,24,48,96,120,144,168)}

\item{only_mapped}{A logical indicator; if set to FALSE will return 'de-novo'
edges that 'exist' in data but are not documented in KEGG}

\item{affy_based}{A logical indicator; if set to TRUE will return 
lists/counts based on probeID instead of gene symbol.}

\item{keep_counts_only}{A logical indicator; if set to FALSE will return 
data frame with lists [of gene symbols or probe ids] as well as counts}

\item{add_fisher_information}{A logical indicator; by default the 
relationships are analyzed for strength of correlation via 
Fisher's Exact Test}

\item{p.adjust.method}{For available methods, type 'p.adjust.methods' into 
command promt and press enter.}
}
\value{
A data frame where each row corresponds to information for pairs of 
experimental gene knock-outs from LINCS data (found in selected pathway).
}
\description{
Get overlap information for pairs of gene knock-outs from LINCS data
}
\examples{
p53_KGML <- get_KGML("hsa04115")
p53_KEGG_mappings <-  expand_KEGG_mappings(p53_KGML)
p53_edges <- expand_KEGG_edges(p53_KGML, p53_KEGG_mappings)

summary <- path_genes_by_cell_type(p53_KEGG_mappings)
p53_HA1E_data <- overlap_info(p53_KGML, p53_KEGG_mappings, 
                               "HA1E", data_type = "100_bing", 
                               only_mapped = FALSE)
}
