% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetGOS_ALL.r
\name{GetGOS_ALL}
\alias{GetGOS_ALL}
\title{Gene ontology for Target Genes.}
\usage{
GetGOS_ALL(
  gene,
  GO = c("topGO"),
  term = c("GOTERM_BP_ALL", "GOTERM_MF_ALL", "GOTERM_CC_ALL"),
  geneIdType = "ALIAS",
  path = tempdir(),
  ontology = c("GO_BP", "GO_MF", "GO_CC"),
  filename
)
}
\arguments{
\item{gene}{List  A String or vector containing the Gene names.}

\item{GO}{A String depicting the chosen GO tool. Choice is "topGO"}

\item{term}{A String depicting the chosen term. Choices are
"GOTERM_BP_ALL","GOTERM_MF_ALL", "GOTERM_CC_ALL".}

\item{geneIdType}{Type of gene Id given as input. Default "ALIAS"}

\item{path}{String. The path where the data is stored if TEXT=TRUE.}

\item{ontology}{Ontology selection for topGO. Choices are
"GO_BP","GO_MF","GO_CC".}

\item{filename}{Name of the file to store Gene Ontology.}
}
\value{
Depending upon the ouput choice data is stored in the path 
        specified. Default option prints output to the console.
}
\description{
Gene ontology for Target Genes.
}
\examples{
\dontrun{
miR="dme-miR-12"
a<-Visualisation(miR,mRNA_type=c("GeneSymbol"),method=c("Both"),
   platform=c("Affy1"),thresh=100)
genes<-a$Target_GeneSymbol
GetGOS_ALL(genes,GO=c("topGO"),term=c("GO_BP"),path=tempdir(),
     filename="test")
 }
}
