% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_multi_cond.R
\name{getRadar_df}
\alias{getRadar_df}
\title{#' Get radar plot of relative numbers of interactions for a certain cell type
#'
#' @param tab_c1 barplot dataframe from Viewpoint generated by getBarplotDF2() containing data for condition 1
#' @param tab_c2 barplot dataframe from Viewpoint generated by getBarplotDF2() containing data for condition 2
#' @param tab_c3 barplot dataframe from Viewpoint generated by getBarplotDF2() containing data for condition 3
#' @param lab_c1 label for condition 1
#' @param lab_c2 label for condition 2
#' @param lab_c3 label for condition 3
#' @param cell_name label of cell type of interest
#'
#' @return plot
#' @importFrom fmsb radarchart
#' @importFrom data.table transpose
getRadarPlot <- function(tab_c1, tab_c2, tab_c3,
                         lab_c1, lab_c2, lab_c3,
                         cell_name){
    if(is.null(tab_c3)){
        df <- merge(tab_c1, tab_c2, by = "Clusters", all = TRUE)
        colnames(df) <- c("Clusters", "nint_c1", "nint_c2")
    } else {
        df <- merge(tab_c1, tab_c2, by = "Clusters", all = TRUE)
        df <- merge(df, tab_c3, by = "Clusters", all = TRUE)
        colnames(df) <- c("Clusters", "nint_c1", "nint_c2", "nint_c3")
    }
    
    df[is.na(df)] <- 0
    
    cluster_names <- df$Clusters
    # add max and min
    max_nint <- max(df[, -1])
    df <- add_column(df, max_nint, .after = "Clusters")
    df <- add_column(df, "min_nint" = 0, .after = "max_nint")
    
    radar_df <- data.table::transpose(df[, -1])
    
    if(is.null(lab_c3)){
        rownames(radar_df) <- c("max", "min", lab_c1, lab_c2)
    } else {
        rownames(radar_df) <- c("max", "min", lab_c1, lab_c2, lab_c3)
    }
    
    colnames(radar_df) <- cluster_names
    
    color <- c("#438ECC", "#E97778", "#00BA38")
    
    fmsb::radarchart(
        radar_df, axistype = 1,
        # Customize the polygon
        pcol = color, 
        pfcol = scales::alpha(color, 0.5), plwd = 2, plty = 1,
        # Customize the grid
        cglcol = "grey", cglty = 1, cglwd = 0.8,
        # Customize the axis
        axislabcol = "grey30", 
        # Variable labels
        vlcex = 1.2, vlabels = colnames(radar_df),
        caxislabels = round(seq(from = 0, to = radar_df["max",1], length.out = 5)), 
        title = cell_name
    )
    legend(
        x = "bottomleft", legend = rownames(radar_df[-c(1,2),]), horiz = FALSE,
        bty = "n", pch = 20 , col = color,
        text.col = "black", cex = 1, pt.cex = 1.5
    )
    
}
Get radar df of relative numbers of interactions for a certain cell type}
\usage{
getRadar_df(tab_c1, tab_c2, tab_c3, lab_c1, lab_c2, lab_c3)
}
\arguments{
\item{tab_c1}{barplot dataframe from Viewpoint generated by getBarplotDF2() containing data for condition 1}

\item{tab_c2}{barplot dataframe from Viewpoint generated by getBarplotDF2() containing data for condition 2}

\item{tab_c3}{barplot dataframe from Viewpoint generated by getBarplotDF2() containing data for condition 3}

\item{lab_c1}{label for condition 1}

\item{lab_c2}{label for condition 2}

\item{lab_c3}{label for condition 3}
}
\value{
df to be then used with fmsb radarchart
}
\description{
#' Get radar plot of relative numbers of interactions for a certain cell type
#'
#' @param tab_c1 barplot dataframe from Viewpoint generated by getBarplotDF2() containing data for condition 1
#' @param tab_c2 barplot dataframe from Viewpoint generated by getBarplotDF2() containing data for condition 2
#' @param tab_c3 barplot dataframe from Viewpoint generated by getBarplotDF2() containing data for condition 3
#' @param lab_c1 label for condition 1
#' @param lab_c2 label for condition 2
#' @param lab_c3 label for condition 3
#' @param cell_name label of cell type of interest
#'
#' @return plot
#' @importFrom fmsb radarchart
#' @importFrom data.table transpose
getRadarPlot <- function(tab_c1, tab_c2, tab_c3,
                         lab_c1, lab_c2, lab_c3,
                         cell_name){
    if(is.null(tab_c3)){
        df <- merge(tab_c1, tab_c2, by = "Clusters", all = TRUE)
        colnames(df) <- c("Clusters", "nint_c1", "nint_c2")
    } else {
        df <- merge(tab_c1, tab_c2, by = "Clusters", all = TRUE)
        df <- merge(df, tab_c3, by = "Clusters", all = TRUE)
        colnames(df) <- c("Clusters", "nint_c1", "nint_c2", "nint_c3")
    }
    
    df[is.na(df)] <- 0
    
    cluster_names <- df$Clusters
    # add max and min
    max_nint <- max(df[, -1])
    df <- add_column(df, max_nint, .after = "Clusters")
    df <- add_column(df, "min_nint" = 0, .after = "max_nint")
    
    radar_df <- data.table::transpose(df[, -1])
    
    if(is.null(lab_c3)){
        rownames(radar_df) <- c("max", "min", lab_c1, lab_c2)
    } else {
        rownames(radar_df) <- c("max", "min", lab_c1, lab_c2, lab_c3)
    }
    
    colnames(radar_df) <- cluster_names
    
    color <- c("#438ECC", "#E97778", "#00BA38")
    
    fmsb::radarchart(
        radar_df, axistype = 1,
        # Customize the polygon
        pcol = color, 
        pfcol = scales::alpha(color, 0.5), plwd = 2, plty = 1,
        # Customize the grid
        cglcol = "grey", cglty = 1, cglwd = 0.8,
        # Customize the axis
        axislabcol = "grey30", 
        # Variable labels
        vlcex = 1.2, vlabels = colnames(radar_df),
        caxislabels = round(seq(from = 0, to = radar_df["max",1], length.out = 5)), 
        title = cell_name
    )
    legend(
        x = "bottomleft", legend = rownames(radar_df[-c(1,2),]), horiz = FALSE,
        bty = "n", pch = 20 , col = color,
        text.col = "black", cex = 1, pt.cex = 1.5
    )
    
}
Get radar df of relative numbers of interactions for a certain cell type
}
