\name{readInterestResults}
\alias{readInterestResults}
\title{
	Read interest/interest.sequential results text files
}
\description{
Reads one or multiple text file results generated by the \code{\link{interest}}
or \code{\link{interest.sequential}} functions and builds an object of 
\code{\link[SummarizedExperiment]{SummarizedExperiment-class}} class. 
}
\usage{
readInterestResults(resultFiles, sampleNames, 
	sampleAnnotation, commonColumns, freqCol, scaledRetentionCol,
	scaleLength, scaleFragment, reScale=FALSE, geneIdCol, 
	repeatsTableToFilter=c())
}
\arguments{
\item{resultFiles}{ 
Vector of character strings which includes the path to the tab-separated files 
resulted by the \code{\link{interest}} function.
}
\item{sampleNames}{
Vector of character strings which includes the  name of the samples. It should 
be the same size as the \code{resultFiles} parameter. 
}
\item{sampleAnnotation}{
Data frame with the same row number as the size of \code{resultFiles} and  
\code{sampleNames} parameter. The column names represent the annotation names 
and values in each column represent the annotations of the samples.
}
\item{commonColumns}{
Columns in the result file which include intron/exon annotations and are common
across all files defined in \code{resultFiles}.
}
\item{freqCol}{
Column in the result file which include the read counts for introns/exons.
}
\item{scaledRetentionCol}{
Column in the result file which include the scaled retention values for 
introns/exons.
}
\item{scaleLength}{
Logical value, indicating whether the intron/exon retention levels are scaled
to the length of the introns/exons. If \code{reScale} is \code{TRUE} the scaled
retention levels would be rescalculated when reading the data. 
}
\item{scaleFragment}{
Logical value, indicating whether the intron/exon retention levels are scaled
to the fragments mapped to the genes. If \code{reScale} is \code{TRUE} the 
scaled retention levels would be rescalculated when reading the data.
}
\item{reScale}{
Logical value, indicating whether the scaled retention levels would be 
rescalculated when reading the data. By default it does not calculate and 
trusts the user to set the \code{scaleLength} and \code{scaleFragment} 
parameters correctly, i.e. as it was set in the \code{interest()} or 
\code{interest.sequential()} analysis.
}
\item{geneIdCol}{
The number or name of the column in \code{resultFiles} which represents the 
gene/transcript names. It would be used for summing up the number of mapped 
fragments to the genes when scaling the retention levels. It is only used if 
\code{reScale} and \code{scaleFragment} arguments are set \code{TRUE}.}
\item{
repeatsTableToFilter}{A data.frame table with similar stucture to the 
\code{reference}. It includes \code{chr}, \code{begin}, and \code{end} columns.
If defined, all reads mapped to the described regions would be ingnored and the
Intron/exon lengths would be corrected to exclude the to exclude the regions 
with repetitive DNA sequences. See \code{\link{getRepeatTable}}. It is only 
used if \code{reScale} and \code{scaleLength} arguments are set \code{TRUE}.}
}
\value{
An object of calss 
\code{\link[SummarizedExperiment]{SummarizedExperiment-class}}.
}

\seealso{
	\code{\link{interest}},
	\code{\link{InterestResult}}.
}

\author{Ali Oghabian}

\examples{


geneId<- paste("gene", c(rep(1,7), rep(2,7), rep(3,7), rep(4,7)), 
	sep="_")
readCnt1<- sample(1:100, 28)
readCnt2<- sample(1:100, 28)
readCnt3<- sample(1:100, 28)
readCnt4<- sample(1:100, 28)
fpkm1<- readCnt1/(tapply(readCnt1, geneId, sum))[geneId]
fpkm2<- readCnt2/(tapply(readCnt2, geneId, sum))[geneId]
fpkm3<- readCnt3/(tapply(readCnt3, geneId, sum))[geneId]
fpkm4<- readCnt4/(tapply(readCnt4, geneId, sum))[geneId]

#Create tmp director
tmpDir=file.path(tempdir(),"InterestResult")
dir.create(tmpDir)

# Build text files similar to files resulted by interest
dfTmp=data.frame( 
		int_ex=rep(c(rep(c("exon","intron"),3),"exon"),4),
		int_ex_num= rep(c(1,1,2,2,3,3,4),4),         
		int_type=rep(c(NA,"U2",NA,"U12",NA,"U2",NA),4),
		strand=rep("*",28),
		gene_id= geneId,
		sam1_readCnt=readCnt1,
		sam2_readCnt=readCnt2,
		sam3_readCnt=readCnt3,
		sam4_readCnt=readCnt4,
		sam1_fpkm=fpkm1,
		sam2_fpkm=fpkm2,
		sam3_fpkm=fpkm3,
		sam4_fpkm=fpkm4
)

writeDf<-function(df, file){
	write.table(df, file, col.names=TRUE, 
		row.names=FALSE, quote=FALSE, sep='\t')
}

writeDf(dfTmp[, c(1:5,6,10)], paste(tmpDir, "df1.tsv", sep="/"))
writeDf(dfTmp[, c(1:5,7,11)], paste(tmpDir, "df2.tsv", sep="/"))
writeDf(dfTmp[, c(1:5,8,12)], paste(tmpDir, "df3.tsv", sep="/"))
writeDf(dfTmp[, c(1:5,9,13)], paste(tmpDir, "df4.tsv", sep="/"))

# Build object from generated text file results
testObj<-readInterestResults(
	resultFiles=paste(tmpDir, 
		c("df1.tsv", "df2.tsv", "df3.tsv", "df4.tsv"), sep="/"), 
	sampleNames=c("sam1","sam2","sam3","sam4"), 
	sampleAnnotation= data.frame( gender=c("M","M","F","F"),
		health=c("healthy","unhealthy","healthy","unhealthy")), 
	commonColumns=1:5, freqCol=6, scaledRetentionCol=7, 
	scaleLength=FALSE, scaleFragment=TRUE, reScale=FALSE)

#View object
testObj


}

