% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretization.measure.R
\name{discretize3D}
\alias{discretize3D}
\title{Discretize 3-dimensional continuous data into bins}
\usage{
discretize3D(x, y, z, algorithm = c("uniform_width", "uniform_frequency"))
}
\arguments{
\item{x}{a numeric vector of the random variable x.}

\item{y}{a numeric vector of the random variable y.}

\item{z}{a numeric vector of the random variable z.}

\item{algorithm}{two discretization algorithms are available, "uniform_width" is the default.}
}
\value{
discretize3D returns a 3-dimensional count table.
}
\description{
The function of discretize3D is used to assign the observations of three sets of continuous random variables to bins,
and returns a corresponding three-dimensional count table. Two of the most common discretization methods are available:
"uniform width" and "uniform frequency".
}
\details{
Uniform width-based method ("uniform_width") divides the continuous data into N bins with equal width,
while Uniform frequency-based method ("uniform_frequency") divides the continuous data into N bins with (approximate) equal count number.
By default in both methods, the number of bins N is initialized into a round-off value according to the square root of the data size.
}
\examples{
# three vectors that correspond to three continuous random variables
x <- c(0.0, 0.2, 0.2, 0.7, 0.9, 0.9, 0.9, 0.9, 1.0)
y <- c(1.0, 2.0,  12, 8.0, 1.0, 9.0, 0.0, 3.0, 9.0)
z <- c(3.0, 7.0, 2.0,  11,  10,  10,  14, 2.0,  11)

# corresponding count table estimated by "uniform width" algorithm
discretize3D(x,y,z, "uniform_width")

# corresponding count table estimated by "uniform frequency" algorithm
discretize3D(x,y,z, "uniform_frequency")
}
