% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretization.plugin.R
\name{discretize2d.uniform_frequency}
\alias{discretize2d.uniform_frequency}
\title{Discretize two sets of continuous data into 2-dimensional bins by uniform frequency}
\usage{
discretize2d.uniform_frequency(x, y)
}
\arguments{
\item{x}{a numeric vector of the first random variable.}

\item{y}{a numeric vector of the second random variable.}
}
\value{
discretize2d.uniform_frequency returns a 2-dimensional count table.
}
\description{
discretize2d.uniform_frequency assigns the observations of two continuous random variables to bins according to the "uniform frequency" method,
and returns a corresponding 2-dimensional count table.
}
\details{
Uniform frequency-based method ("uniform_frequency") divides the continuous data into N bins with (approximate) equal count number.
The number of bins N is initialized into a round-off value according to the square root of the data size.
}
\examples{
# two numeric vectors corresponding to two continuous random variables
x <- c(0.0, 0.2, 0.2, 0.7, 0.9, 0.9, 0.9, 0.9, 1.0)
y <- c(1.0, 2.0,  12, 8.0, 1.0, 9.0, 0.0, 3.0, 9.0)

# corresponding joint count table estimated by "uniform frequency" algorithm
discretize2d.uniform_frequency(x,y)
}
