% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/15.adjust_proximalCPs.R
\name{adjust_proximalCPs}
\alias{adjust_proximalCPs}
\title{Adjust the proximal CP sites}
\usage{
adjust_proximalCPs(
  CPs,
  PolyA_PWM,
  genome,
  classifier,
  classifier_cutoff,
  shift_range,
  search_point_START,
  step = 1,
  DIST2ANNOAPAP = 1000
)
}
\arguments{
\item{CPs}{the outputs of \code{\link[=search_proximalCPs]{search_proximalCPs()}}}

\item{PolyA_PWM}{PolyA position weight matrix}

\item{genome}{a \link[BSgenome:BSgenome-class]{BSgenome::BSgenome} object}

\item{classifier}{cleanUpdTSeq classifier}

\item{classifier_cutoff}{cutoff value of the classifier}

\item{shift_range}{the searching range for the better CP sites}

\item{search_point_START}{just in case there is no better CP sites}

\item{step}{An integer, specifying an adjusting step, default 1, means
adjusting by each base by cleanUpdTSeq.}

\item{DIST2ANNOAPAP}{An integer, specifying a cutoff for annotate MSE valleys
with known proximal APAs in a given downstream distance. Default is 1500.}
}
\value{
keep same as \code{\link[=search_proximalCPs]{search_proximalCPs()}}, which can be handled by
\code{\link[=polish_CPs]{polish_CPs()}}.
}
\description{
Adjust the proximal CP sites by PolyA PWM and cleanUpdTSeq. A few candidate
sites, which are ranked by MSE from low to high, are used as input for
adjusting. The final sites are the one with best score as PA sites, which are
not necessary from the lowest MSE sites.
}
\seealso{
\code{\link[=search_proximalCPs]{search_proximalCPs()}}, \code{\link[=polish_CPs]{polish_CPs()}}, \code{\link[=adjust_proximalCPsByPWM]{adjust_proximalCPsByPWM()}},
\code{\link[=adjust_proximalCPsByNBC]{adjust_proximalCPsByNBC()}}, \code{\link[=get_PAscore]{get_PAscore()}},\code{\link[=get_PAscore2]{get_PAscore2()}}
}
\author{
Jianhong Ou
}
\keyword{internal}
