% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{refGenes_hg19}
\alias{refGenes_hg19}
\alias{refGenes_mm9}
\title{Gene annotation files for hg19, mm9.}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 27275 rows and 12 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 24487 rows and 12 columns.
}
\usage{
data("refGenes_hg19")

data("refGenes_mm9")
}
\description{
This file was obtained following this steps:
\enumerate{
\item Download from \url{http://hgdownload.soe.ucsc.edu/goldenPath/hg19/database/}
the refGene.sql, knownGene.sql, knownToRefSeq.sql, kgXref.sql tables
\item Import everything it in mysql
\item Generate views for annotation:
}

\if{html}{\out{<div class="sourceCode">}}\preformatted{SELECT kg.`chrom`, min(kg.cdsStart) as CDS_minStart,
max(kg.`cdsEnd`) as CDS_maxEnd, k2a.geneSymbol,
kg.`strand` as GeneStrand, min(kg.txStart) as TSS_minStart,
max(kg.txEnd) as TSS_maxStart,
kg.proteinID as ProteinID, k2a.protAcc as ProteinAcc, k2a.spDisplayID
FROM `knownGene` AS kg JOIN kgXref AS k2a
ON BINARY kg.name = k2a.kgID COLLATE latin1_bin
-- latin1_swedish_ci
-- WHERE k2a.spDisplayID IS NOT NULL and (k2a.`geneSymbol` LIKE 'Tcra\%' or
k2a.`geneSymbol` LIKE 'TCRA\%')
WHERE (k2a.spDisplayID IS NOT NULL or k2a.spDisplayID NOT LIKE '')
and k2a.`geneSymbol` LIKE 'Tcra\%'
group by kg.`chrom`, k2a.geneSymbol
ORDER BY kg.chrom ASC , kg.txStart ASC
}\if{html}{\out{</div>}}
}
\section{Functions}{
\itemize{
\item \code{refGenes_mm9}: Data frame for murine mm9 genome

}}
\keyword{datasets}
