% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-functions.R
\name{HSC_population_plot}
\alias{HSC_population_plot}
\title{Plot of the estimated HSC population size for each patient.}
\usage{
HSC_population_plot(
  estimates,
  project_name,
  timepoints = "Consecutive",
  models = "Mth Chao (LB)"
)
}
\arguments{
\item{estimates}{The estimates data frame, obtained via
\code{\link{HSC_population_size_estimate}}}

\item{project_name}{The project name, will be included in the plot title}

\item{timepoints}{Which time points to plot? One between "All",
"Stable" and "Consecutive"}

\item{models}{Name of the models to plot (as they appear in the column
of the estimates)}
}
\value{
A plot
}
\description{
Plot of the estimated HSC population size for each patient.
}
\examples{
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
aggreg <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    value_cols = c("seqCount", "fragmentEstimate")
)
aggreg_meta <- aggregate_metadata(
    association_file = association_file
)
estimate <- HSC_population_size_estimate(
    x = aggreg,
    metadata = aggreg_meta,
    stable_timepoints = c(90, 180, 360),
    cell_type = "Other"
)
p <- HSC_population_plot(estimate$est, "PJ01")
p
}
\seealso{
Other Plotting functions: 
\code{\link{CIS_volcano_plot}()},
\code{\link{circos_genomic_density}()},
\code{\link{fisher_scatterplot}()},
\code{\link{integration_alluvial_plot}()},
\code{\link{sharing_heatmap}()},
\code{\link{sharing_venn}()},
\code{\link{top_abund_tableGrob}()},
\code{\link{top_cis_overtime_heatmap}()}
}
\concept{Plotting functions}
