% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_em_algorithm.R
\name{.multi_prior_estimation}
\alias{.multi_prior_estimation}
\title{Compute Multi-INTACT prior parameter estimates and gene product relevance
probabilities.}
\usage{
.multi_prior_estimation(
  df,
  pi_init,
  chisq_vec,
  chisq_dof = 2,
  z_1,
  z_2,
  fp_coloc
)
}
\arguments{
\item{df}{A data frame with marginal z-scores for the TWAS analyses of
gene products 1 and 2, as well as the multivariate Wald chi-square statistic
from the joint analysis.}

\item{pi_init}{Initialization of prior parameters to be estimated. The first
entry should be the qvalue estimate for pi0. The second parameter should
be the gene-product-1-only parameter; the third should be the
gene-product-2-only parameter, and the fourth should be the
gene-product-1+2-parameter.}

\item{chisq_vec}{A numeric vector of multivariate Wald chi-square test
statistics. The order of this vector should match z_1, z_2, and fp_coloc.}

\item{chisq_dof}{A numeric vector containing the chi-square test statistic
degrees of freedom under the null. Default is 2.}

\item{z_1}{A numeric vector of TWAS test statistics for gene product 1.
The order of this vector should match chisq_vec, z_2, and fp_coloc.}

\item{z_2}{A numeric vector of TWAS test statistics for gene product 2.
The order of this vector should match chisq_vec, z_1, and fp_coloc.}

\item{fp_coloc}{A vector of aggregated colocalization evidence. The default
is the max of all GLCPs, truncated at 0.05. The order should match
chisq_vec, z_1, and z_2.}
}
\value{
A list containing a data frame with the model posteriors
(posterior_1, posterior_2, and posterior_12),gene product relevance
probabilities (GPRP_1 and GPRP_2), a vector of prior parameter estimates and
a Boolean indicating convergence of the EM algorithm.
}
\description{
Compute Multi-INTACT prior parameter estimates and gene product relevance
probabilities.
}
