% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/modelRates-methods.R
\name{modelRates}
\alias{modelRates}
\alias{modelRates,INSPEcT-method}
\title{Launch the modeling process}
\usage{
modelRates(
  object,
  estimateRatesWith = c("der", "int"),
  useSigmoidFun = TRUE,
  nInit = 10,
  nIter = 300,
  Dmin = 1e-06,
  Dmax = 10,
  seed = NULL,
  BPPARAM = SerialParam()
)

\S4method{modelRates}{INSPEcT}(
  object,
  estimateRatesWith = c("der", "int"),
  useSigmoidFun = TRUE,
  nInit = 10,
  nIter = 300,
  Dmin = 1e-06,
  Dmax = 10,
  seed = NULL,
  BPPARAM = SerialParam()
)
}
\arguments{
\item{object}{An object of class INSPEcT}

\item{estimateRatesWith}{Either "int" or "der". With "int" the degradation and processing
rates are estimated integrating the system between one time point and the following. 
With "der" degradation and processing rates are estimated using the derivative of total
and pre mRNA. (default is "der")}

\item{useSigmoidFun}{A logical, whether to choose between sigmoid and impulse function 
to fit rates and concentrations. In case not, always impulse function is used. 
(default is TRUE)}

\item{nInit}{number of optimization to find the best functional representation of each rate (by default 10)}

\item{nIter}{number of max iteration during optimization (default is 300)}

\item{Dmin}{lower bondary for degradation rates in the NoNascent mode (default 1e-06)}

\item{Dmax}{upper bondary for degradation rates in the NoNascent mode (default 10)}

\item{seed}{A numeric, indicatindg the seed to be set for reproducible results. If NULL it is randomly selected (default NULL)}

\item{BPPARAM}{Parallelization parameters for bplapply. By default SerialParam()}
}
\value{
An object of class INSPEcT with modeled rates
}
\description{
Launch the modeling process with parameters set with \code{\link{modelingParams}}

This method model the synthesis, degradation and processing rates after their estimation by the constructor function
\code{\link{newINSPEcT}}. Estimated rates are not guaranteed to optimally describes provided input data yet. 
To this purpose, modeled rates can be generated and genes can be assigned to a transcriptional regulatory mechanism.
Modeled rates can be accessed via the method \code{\link{viewModelRates}} and gene classification according 
to the regulatory mechanism can be accessed by \code{\link{geneClass}}. The modeling options used for the 
modeling can be later accessed by the user via \code{\link{modelingParams}}. After modeling, model selection is run
by the method \code{\link{calculateRatePvals}} with default parameters.
}
\examples{
if( Sys.info()["sysname"] != "Windows" ) {
	nascentInspObj10 <- readRDS(system.file(package='INSPEcT', 'nascentInspObj10.rds'))
	## models removal
	nascentInspObjThreeGenes <- removeModel(nascentInspObj10[1:3])
	nascentInspObjThreeGenes <- modelRates(nascentInspObjThreeGenes, 
	  seed=1, BPPARAM=SerialParam())
	## view modeled synthesis rates
	viewModelRates(nascentInspObjThreeGenes, 'synthesis')
	## view gene classes
	geneClass(nascentInspObjThreeGenes)
}
}
\seealso{
\code{\link{viewModelRates}}, \code{\link{calculateRatePvals}}, \code{\link{geneClass}}
}
