% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/makeModelRates-methods.R
\name{makeModelRates}
\alias{makeModelRates}
\alias{makeModelRates,INSPEcT_model-method}
\alias{makeModelRates,INSPEcT-method}
\title{Calculate modeled rates and concentrations}
\usage{
makeModelRates(object, ...)

\S4method{makeModelRates}{INSPEcT_model}(object, ...)

\S4method{makeModelRates}{INSPEcT}(object, ...)
}
\arguments{
\item{object}{An object of class INSPEcT_model}

\item{...}{additional arguments
tpts : A vector of time points where rates and concentrations have to be evaluated}
}
\value{
An object of class ExpressionSet containing the modeled rates and concentrations
}
\description{
This function is used to evaluate rates and concentrations after modeling of the 
rates has been run with \code{\link{modelRates}}. The modeled rates are in functional 
form and can be evaluated at any time points.

This method can be used to regenerate the rates assiciated to the modeling, in case
some testing parameters has changed.
}
\examples{
nascentInspObj10 <- readRDS(system.file(package='INSPEcT', 'nascentInspObj10.rds'))
viewModelRates(nascentInspObj10, 'degradation')
## force every degradation rate to be accepted as variable (makeModelRates is called internally)
nascentInspObj10 <- calculateRatePvals(nascentInspObj10, p_variability = c(.05,.05,1))
viewModelRates(nascentInspObj10, 'degradation')
}
