% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap-up-functions.R
\name{inspectFromPCR}
\alias{inspectFromPCR}
\title{Wrapper function from PCR quantifications}
\usage{
inspectFromPCR(
  totalRNA_table,
  nascentRNA_table = NULL,
  labeling_time = NULL,
  estimateRatesWith = "der",
  useSigmoidFun = TRUE,
  file = NULL
)
}
\arguments{
\item{totalRNA_table}{Exonic quantification, intronic quantification and experimental design 
associated to totalRNA of a single gene quantified by PCR. They could be provided directly as a 
'data.frame', or as a path to the file containing the information. Possible file
formats are csv' (comma-separated-values), 'tsv' (comma-separated-values), or 'xls' (Excel).
'totalRNA_table' must have 3 colums named 'condition', 'total_exonic' and 'total_intronic'.
'condition' is a column indicating the experimental condition, a character vector (containing, for example, 'WT'
or 'KD') in case of steady-state experiments, or numerical values indicating the time from the unperturbed
condition in case of time-course analysis. 'total_exonic' and 'total_intronic' contains abundance of gene
measured in its exonic and intronic regions, respectively, in the total RNA fraction.}

\item{nascentRNA_table}{similar to 'totalRNA_table' but referred to nascent RNA fraction. In this case, 
colums names must be 'condition', 'nascent_exonic' and 'nascent_intronic'. In case this infromation 
is not provided, INSPEcT- analysis is run. If otherwise this information is present, INSPEcT+ analysis is run.}

\item{labeling_time}{A numeric indicating the time of labeling exposure to the modified nucleotide.
To be indicated only in case of INSPEcT+ analysis.}

\item{estimateRatesWith}{Either "int" or "der". With "int" the degradation and processing
rates are estimated integrating the system between one time point and the following. 
With "der" degradation and processing rates are estimated using the derivative of total
and pre mRNA. (default is "der")}

\item{useSigmoidFun}{A logical, whether to choose between sigmoid and impulse function 
to fit rates and concentrations. In case not, always impulse function is used. 
(default is TRUE)}

\item{file}{A character indicating where the output of the analysis will be stored. If not provided 
the file name will be created automaticcally and saved on the current folder.}
}
\description{
Function to run the whole INSPEcT differential rate analysis procedure with a single line. 
The function save the output analysis to file that can be later loaded in the R environment 
or in the INSPEcT-GUI.
}
\examples{
if( Sys.info()["sysname"] != "Windows" ) {
totalAnnTabPCR <- system.file(package = 'INSPEcT', 'totalAnnTabPCR.csv')
nascentAnnTabPCR <- system.file(package = 'INSPEcT', 'nascentAnnTabPCR.csv')
inspectFromPCR(totalAnnTabPCR, nascentAnnTabPCR, labeling_time=1/6)
}
}
