% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/chisqtest-methods.R
\name{convergence}
\alias{convergence}
\alias{convergence,INSPEcT-method}
\title{Retrieve the convergence for the selected models of each gene}
\usage{
convergence(object)

\S4method{convergence}{INSPEcT}(object)
}
\arguments{
\item{object}{An object of class INSPEcT or INSPEcT_model}
}
\value{
A vector of numeric
}
\description{
This method is used to retrieve the convergence of the models
that have been selected to better represent the behavior of each gene.
0 is converged, 1 not converged, 10 degenerated
}
\examples{
nascentInspObj10 <- readRDS(system.file(package='INSPEcT', 'nascentInspObj10.rds'))
convergence(nascentInspObj10)
}
