% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/steady-state-methods.R
\name{compareSteady}
\alias{compareSteady}
\alias{compareSteady,INSPEcT-method}
\title{Generate an object of class INSPEcT_diffsteady from an object of class INSPEcT}
\usage{
compareSteady(inspectIds, BPPARAM = SerialParam())

\S4method{compareSteady}{INSPEcT}(inspectIds, BPPARAM = SerialParam())
}
\arguments{
\item{inspectIds}{An object of calss INSPEcT with two conditions}

\item{BPPARAM}{Configuration for BiocParallel parallelization. By default is set to SerialParam()}
}
\value{
An object of class INSPEcT_diffsteady which contains both the absolute 
quantification of the rates as well as the comparison with the statistical significance
associated for each gene and rate. (See \code{\link{INSPEcT_diffsteady-class}})
}
\description{
This method compares two object of class INSPEcT in order to identify differential usage
of synthesis, processing or degradation rates in two different steady-state conditions. 
The two INSPEcT objects must have been profiled with replicates in order to provide
a statistical significance to the differences between their rates.
}
\examples{
if( Sys.info()["sysname"] != "Windows" ) {
  data('allcounts', package='INSPEcT')
  data('featureWidths', package='INSPEcT')
  data('libsizes', package='INSPEcT')
  
  nascentCounts<-allcounts$nascent
  matureCounts<-allcounts$mature
  conditions<-letters[1:11]
  expDes<-rep(conditions,3)
  tL<-1/6
  
  nasExp_DESeq2<-quantifyExpressionsFromTrCounts(
        allcounts=nascentCounts
        ,libsize=nascentLS
        ,exonsWidths=exWdths
        ,intronsWidths=intWdths
        ,experimentalDesign=expDes)
  
  matExp_DESeq2<-quantifyExpressionsFromTrCounts(
        allcounts=matureCounts
        ,libsize=totalLS
        ,exonsWidths=exWdths
        ,intronsWidths=intWdths
        ,experimentalDesign=expDes)
 
  nasFullObj <- newINSPEcT(
        tpts=conditions
        ,labeling_time=tL
        ,nascentExpressions=nasExp_DESeq2
        ,matureExpressions=matExp_DESeq2)
  
  diffrates = compareSteady(nasFullObj[,c(1,11)])
}
}
