% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extract-methods.R
\docType{methods}
\name{combine}
\alias{combine}
\alias{combine,INSPEcT,INSPEcT-method}
\title{Combine different Objects of Class INSPEcT}
\usage{
\S4method{combine}{INSPEcT,INSPEcT}(x, y, ...)
}
\arguments{
\item{x}{An object of class INSPEcT}

\item{y}{An object of class INSPEcT}

\item{...}{Additional objects of class INSPEcT}
}
\value{
An Object of class INSPEcT
}
\description{
This method combines the information coming from different Objects of INSPEcT class.
Requirements for two or more object to be combined together are:
\itemize{
\item they must be either modeled or either not modeled
\item they must have the same time points
\item they must have the same modeling parameters
}
}
\details{
In case the same gene is contained in more than one object that the user
tries to combine, the information from one object will be used and a 
warning will be reported
}
\examples{
nascentInspObj10 <- readRDS(system.file(package='INSPEcT', 'nascentInspObj10.rds'))
nascentInspObj10_2genes <- nascentInspObj10[1:2]
nascentInspObj10_5genes <- nascentInspObj10[6:10]
nascentInspObj10_7genes <- combine(nascentInspObj10_2genes, nascentInspObj10_5genes)

}
