% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_function.R
\name{permutation_pc}
\alias{permutation_pc}
\title{Permutations to build differential network based on partial correlation analysis}
\usage{
permutation_pc(m, p, n_group_1, n_group_2, data_group_1, data_group_2,
  rho_group_1_opt, rho_group_2_opt)
}
\arguments{
\item{m}{This is the number of permutations desired.}

\item{p}{This is the number of biomarker candidates present.}

\item{n_group_1}{This is the number of subjects in group 1.}

\item{n_group_2}{This is the number of subjects in group 2.}

\item{data_group_1}{This is a \eqn{n*p} matrix containing group 1 data.}

\item{data_group_2}{This is a \eqn{n*p} matrix containing group 2 data.}

\item{rho_group_1_opt}{This is an optimal tuning parameter to obtain a sparse differential 
network for group 1.}

\item{rho_group_2_opt}{This is an optimal tuning parameter to obtain a sparse differential
network for group 2.}
}
\value{
A multi-dimensional matrix that contains the permutation result.
}
\description{
A permutation test that randomly permutes the sample labels in distinct
    biological groups for each biomolecule. The difference in paired partial correlation
    is considered statistically significant if it falls into the 2.5% tails on either end of the 
    empirical distribution curve.
}
