% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{PCAElbowPlot}
\alias{PCAElbowPlot}
\alias{PCAElbowPlot.SingleCellExperiment}
\alias{PCAElbowPlot,SingleCellExperiment-method}
\title{Elbow plot of the standard deviations of the principal components}
\usage{
PCAElbowPlot.SingleCellExperiment(object, return.plot)

\S4method{PCAElbowPlot}{SingleCellExperiment}(object, return.plot = FALSE)
}
\arguments{
\item{object}{object of class 'iloreg'}

\item{return.plot}{logical indicating if the ggplot2 object
should be returned (default FALSE)}
}
\value{
ggplot2 object if return.plot=TRUE
}
\description{
Draw an elbow plot of the standard deviations of the principal components
to deduce an appropriate value for p.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,k=5,r=1)
sce <- RunPCA(sce,p=5)
PCAElbowPlot(sce)

}
\keyword{PCA}
\keyword{elbow}
\keyword{plot}
