% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{MergeClusters}
\alias{MergeClusters}
\alias{MergeClusters.SingleCellExperiment}
\alias{MergeClusters,SingleCellExperiment-method}
\title{Merge clusters}
\usage{
MergeClusters.SingleCellExperiment(object, clusters.to.merge, new.name)

\S4method{MergeClusters}{SingleCellExperiment}(object, clusters.to.merge = "", new.name = "")
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}

\item{clusters.to.merge}{a character or numeric vector for the names of
the clusters to merge}

\item{new.name}{a character for the new name of the merged cluster.
If left empty, the new cluster name is formed by separating
the cluster names by "_".}
}
\value{
object of \code{SingleCellExperiment} class
}
\description{
MergeClusters function enables merging clusters and naming the newly
formed cluster.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,k=5,r=1)
sce <- RunPCA(sce,p=5)
sce <- HierarchicalClustering(sce)
sce <- SelectKClusters(sce,K=5)
sce <- MergeClusters(sce,clusters.to.merge=c(1,2),new.name="merged1")

}
\keyword{clusters}
\keyword{merge}
