% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_resource.R
\name{add_resource}
\alias{add_resource}
\title{Add a hub resource}
\usage{
add_resource(package, fields, metafile = "metadata.csv")
}
\arguments{
\item{package}{A \code{character(1)} with the name of an existing hub package or
the path to a newly created (not yet submitted/accepted) hub package.}

\item{fields}{A named list with the data to be added to the
resource. Elements and content of the list are described in \code{?hub_metadata}.}

\item{metafile}{A \code{character(1)} with the name of the metadata csv file.
The default file name is 'metadata.csv'.}
}
\value{
Path to metadata file where resource was added
}
\description{
This function adds a hub resource to the AH or EH package metadata.csv file.
It can be used while creating a new hub package or for adding data to an
existing package.
}
\examples{
## create a mock package
pkgdir <- tempdir()
create_pkg(file.path(pkgdir, "recordPkg"), "ExperimentHub")

## create a metadata record
meta <- hub_metadata(
    Title = "ENCODE",
    Description = "a test entry",
    BiocVersion = "4.1",
    Genome = NA_character_,
    SourceType = "JSON",
    SourceUrl = "https://www.encodeproject.org",
    SourceVersion = "x.y.z",
    Species = NA_character_,
    TaxonomyId = as.integer(9606),
    Coordinate_1_based = NA,
    DataProvider = "ENCODE Project",
    Maintainer = "tst person <tst@email.com>",
    RDataClass = "data.table",
    DispatchClass = "Rda",
    Location_Prefix = "s3://annotationhub/",
    RDataPath = "ENCODExplorerData/encode_df_lite.rda",
    Tags = "ENCODE:Homo sapiens"
)

## add the record to the metadata
add_resource(file.path(pkgdir, "recordPkg"), meta)

}
