% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diamond.R
\name{getDiamondInsulation}
\alias{getDiamondInsulation}
\alias{getBorders}
\title{Contact map insulation}
\usage{
getDiamondInsulation(x, window_size = NULL, BPPARAM = BiocParallel::bpparam())

getBorders(x, weak_threshold = 0.2, strong_threshold = 0.5)
}
\arguments{
\item{x}{A \code{HiCExperiment} object over a full genome}

\item{window_size}{Which window size to use to compute diamond insulation
score (default: 10 * resolution)}

\item{BPPARAM}{BiocParallel parallelization settings}

\item{weak_threshold}{Less stringent cutoff to call borders in the
diamond insulation score}

\item{strong_threshold}{More stringent cutoff to call borders in the
diamond insulation score}
}
\value{
a \code{HiCExperiment} object with additional \code{insulation} metadata,
containing the diamond insulation score computed
}
\description{
Computes diamond insulation score along the entire genome
}
\examples{
library(HiContacts)
hic <- contacts_yeast() |> 
  refocus('II:1-300000') |> 
  zoom(1000)
diams <- getDiamondInsulation(hic)
getDiamondInsulation(diams)
}
