% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Neighbours_combined}
\alias{Neighbours_combined}
\title{Neighbours Function for the Potts Model}
\usage{
Neighbours_combined(potts_data, N, proposed_value = NULL)
}
\arguments{
\item{potts_data}{A numeric \eqn{N \times N} matrix representing the current configuration 
of the Potts model. Each element corresponds to the state of a particular site.}

\item{N}{An integer specifying the dimension of the \code{potts_data} lattice (i.e., the 
lattice has \code{N} rows and \code{N} columns).}

\item{proposed_value}{(Optional) A numeric \eqn{N \times N} matrix representing a proposed 
configuration of the Potts model. If provided, the function computes neighbor relationships 
relative to this proposed configuration; otherwise, it uses a shifted version of \code{potts_data} 
to determine neighbors.}
}
\value{
A numeric \eqn{N \times N} matrix, \code{Neighbours_total}, where each element is the count of 
how many of the four neighbors match the state of that site.
}
\description{
Computes the number of agreeing neighbors for each site in a Potts model lattice.
The Potts model is a generalization of the Ising model, where each site on a lattice can 
take on multiple states. By counting how many of a site's four neighbors share the same 
state, this function provides a measure of clustering within the lattice.
}
\details{
The function checks each site and compares it with its four directional neighbors 
(up, down, left, right). For each neighbor that has the same state, a value of 1 is assigned. 
Summing these values for each site results in a measure of how "similar" the immediate neighborhood 
is to that site.

Internally, the function:
\enumerate{
  \item Uses \code{shift_matrix} to create versions of the lattice shifted in each of the four directions.
  \item Uses \code{compute_neighbours} to determine if neighboring positions match in state.
  \item Sums the contributions from all four directions to form the \code{Neighbours_total} matrix.
}

By providing an optional \code{proposed_value} matrix, this function can be integrated into an 
MCMC algorithm where new configurations are proposed and evaluated 
based on their local coherence.
}
\examples{

# Suppose we have a 5x5 Potts model lattice:
potts_data <- matrix(sample(1:3, 25, replace = TRUE), ncol = 5)
N <- 5

# Compute the neighbors without a proposed configuration:
neigh <- Neighbours_combined(potts_data, N)
neigh

# Suppose we propose a new configuration:
proposed <- matrix(sample(1:3, 25, replace = TRUE), ncol = 5)

# Evaluate neighbors for the proposed configuration:
neigh_proposed <- Neighbours_combined(potts_data, N, proposed_value = proposed)
neigh_proposed

}
\keyword{internal}
