% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Brick_load_data_from_sparse}
\alias{Brick_load_data_from_sparse}
\title{Identify compartments in the Hi-C data}
\usage{
Brick_load_data_from_sparse(
    Brick,
    table_file,
    delim = " ",
    resolution = NULL,
    batch_size = 1e+06,
    matrix_chunk = 2000,
    col_index = c(1, 2, 3),
    remove_prior = FALSE
)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created with
Create_many_Brick.}

\item{table_file}{Path to the file that will be loaded}

\item{delim}{\strong{Optional}. Default " "
The delimiter of the matrix file.}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}

\item{batch_size}{\strong{Optional} Default 1000000
Number of rows to read with each iteration from a sparse matrix.}

\item{matrix_chunk}{\strong{Optional} Default 2000
The nxn matrix square to fill per iteration to a Brick object.}

\item{col_index}{\strong{Optional}. Default "c(1,2,3)".
A character vector of length 3 containing the indexes of the required
columns in the table file. the first index, corresponds to bin1, the
second to bin2 and the third to the signal value.}

\item{remove_prior}{\strong{Optional}. Default FALSE
If a matrix was loaded before, it will not be replaced. Use remove_prior to
override and replace the existing matrix.}
}

\value{
A dataframe containing the chromosome genomic coordinates and the
first three principal components.
}

\description{
\code{Brick_load_data_from_sparse} loads data from a table like file, such as
sparse matrices.
}
\examples{
\dontrun{
Bintable.path <- system.file(file.path("extdata", "Bintable_100kb.bins"), 
package = "HiCBricks")

out_dir <- file.path(tempdir(), "get_vector_val_test")
if(!file.exists(out_dir)){
    dir.create(out_dir)
}

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
    bin_delim = " ", output_directory = out_dir, file_prefix = "Test",
    experiment_name = "Vignette Test", resolution = 100000,
    remove_existing = TRUE)

Matrix_file <- system.file(file.path("extdata", 
"Sexton2012_yaffetanay_CisTrans_100000_corrected_chr2L.txt.gz"), 
package = "HiCBricks")

Brick_load_matrix(Brick = My_BrickContainer, chr1 = "chr2L", 
chr2 = "chr2L", matrix_file = Matrix_file, delim = " ", 
remove_prior = TRUE, resolution = 100000)

Brick_export_to_sparse(Brick = My_BrickContainer, 
out_file = file.path(out_dir, "example_out.txt"), 
remove_file = TRUE, sep = " ", 
resolution = 100000)

Brick_load_data_from_sparse(Brick = My_BrickContainer, 
table_file = file.path(out_dir, "example_out.txt"), 
delim = " ", resolution = 100000, col_index = c(3,4,5))
    
}

}
