% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{install_CondaSysReqs}
\alias{install_CondaSysReqs}
\title{Install Conda requirements listed in the System Requirement field of description}
\usage{
install_CondaSysReqs(
  pkg,
  channels = NULL,
  env = NULL,
  pathToMiniConda = NULL,
  updateEnv = FALSE,
  SysReqsAsJSON = FALSE,
  SysReqsSep = ",",
  verbose = FALSE,
  mamba = FALSE
)
}
\arguments{
\item{pkg}{Package to install Conda System Requirements from.}

\item{channels}{Channels for miniconda (bioconda and conda-forge are defaults).}

\item{env}{Name of Conda environment to install tools into.}

\item{pathToMiniConda}{NULL Path to miniconda installation}

\item{updateEnv}{Update existing package's conda environment if already installed.}

\item{SysReqsAsJSON}{Parse the SystemRequirements in JSON format (see Details). Default is TRUE.}

\item{SysReqsSep}{Separator used in SystemRequirement field.}

\item{verbose}{Print system messages from conda on progress (Default is FALSE). There is a third option "silent" which suppresses Herper and Conda messaging.}

\item{mamba}{A logical about whether to use the mamba solver to speed up the resolution of environment dependencies (Default is FALSE).}
}
\value{
Nothing returned. Output written to file.
}
\description{
Install Conda requirements
}
\details{
This function will install any software listed as a System Requirement in the provided R package.
For a more detailed walkthrough check our webpage: https://rockefelleruniversity.github.io/Herper_Page/
}
\author{
Thomas Carroll and Matt Paul
}
