% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{pvalue_to_zscore}
\alias{pvalue_to_zscore}
\title{Convert p-value matrix to a z-score matrix}
\usage{
pvalue_to_zscore(mat.in, one.sided = TRUE, log.p = FALSE, inf.zscore = 16)
}
\arguments{
\item{mat.in}{matrix of p-values}

\item{one.sided}{p-values one-sided}

\item{log.p}{are p-values log transformed?}

\item{inf.zscore}{infinite z-scores are capped to this value}
}
\value{
matrix of z-scores
}
\description{
Convert p-value matrix to a z-score matrix
}
\examples{
mat <- matrix(runif(100), nrow=10)
rownames(mat) <- paste0("A;",seq_len(nrow(mat)))
pvalue_to_zscore(mat)
}
