% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{convertSequenceDSToProbeDS}
\alias{convertSequenceDSToProbeDS}
\title{Convert HERONSequenceDataSet to HERONProbeDataSet}
\usage{
convertSequenceDSToProbeDS(seq_ds, probe_meta)
}
\arguments{
\item{seq_ds}{a HERONSequenceDataSet object}

\item{probe_meta}{optional data.frame with the PROBE_SEQUENCE, PROBE_ID
columns

the probe meta data frame can be provided within the metadata()$probe_meta
or as a argument to the function.  The argument supersedes the metadata
list.}
}
\value{
HERONProbeDataSet
}
\description{
Convert HERONSequenceDataSet to HERONProbeDataSet
}
\examples{
data(heffron2021_wuhan)
probe_ds <- convertSequenceDSToProbeDS(heffron2021_wuhan)
probe_meta <- metadata(heffron2021_wuhan)$probe_meta
probe_ds <- convertSequenceDSToProbeDS(heffron2021_wuhan, probe_meta)
}
