% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Auto_WGCNA.R
\name{Data_Prep}
\alias{Data_Prep}
\title{Discretizes biological assay data in preparation for bayensian network 
learning}
\usage{
Data_Prep(
  Auto_WGCNA_OUTPUT = NULL,
  Remove_ME0 = FALSE,
  Numeric_Pheno_scores = NULL,
  xCell_Signatures = NULL,
  ibreaks = 60
)
}
\arguments{
\item{Auto_WGCNA_OUTPUT}{R object generated from Auto_WGCNA function.}

\item{Remove_ME0}{a logical value. If FALSE (default), ME0 is not 
removed.
If TRUE the eigengene for module 0 is removed prior to analysis.}

\item{Numeric_Pheno_scores}{a data.frame with rows indicating sample ID 
and columns representing additional phenotype data to be included in 
BN learning. If NULL (default) no data will be included. If provided, the
data.frame will be merged with MEs and discretized into three levels.}

\item{xCell_Signatures}{the name of the text file generated by 
xCell that 
contains the cell signature scores. If NULL (default) the only module 
eigenegnes will be processed. If not NULL and if 
Auto_WGCNA_OUTPUT is NULL,
cell signature scores will be discretized.}

\item{ibreaks}{an integer that indicates the number of ibreaks 
used for 
discretization.
The default value is 60.}
}
\value{
a list containing a data.frame with 
module eigenegnes merged with Xcell signature scores and 
discretized into
three levels: L, M, H. If Auto_WGCNA_OUTPUT is NULL, both scaled and 
discretized cell signatures will be return.
}
\description{
Discretizes biological assay data in preparation for bayensian network 
learning
}
\note{
Please verify that the sample name formatting is 
consistent between 
both datasets. Rownames in the module eigengenes data.frame 
and the column 
names of xCell signatures scores text file are matched for 
merging. Only 
samples that are present in both will be processed!
}
\examples{
file_dir<-system.file("extdata", "IRIS_xCell_sig.txt", 
package = "GmicR", mustWork = TRUE)
Disc_Xcell_sig<-Data_Prep(xCell_Signatures=file_dir, ibreaks = 10)
Disc_Xcell_sig$disc_data
}
