% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gloscope_proportion.R
\name{gloscopeProp}
\alias{gloscopeProp}
\title{Calculate divergence between all sample pairs' cell type proportion}
\usage{
gloscopeProp(
  cell_sample_ids,
  cell_type_ids,
  ep = 0,
  dist_metric = c("KL", "JS", "TV")
)
}
\arguments{
\item{cell_sample_ids}{a vector of the samples IDs each cell comes from. Length
must match the number of element in `cell_type_ids`}

\item{cell_type_ids}{a vector of user defined cell type}

\item{ep}{an numeric value added to the summary counts. Default ep = 0 means
nothing will be added.}

\item{dist_metric}{metric to calculate the divergence between samples.}
}
\value{
clusprop_dist a symmetric matrix of divergences
}
\description{
This function calculates a matrix of pairwise divergences
  between input samples' cell type proportion.
}
\details{
Options for `dist_metric` are as follows: "KL" calculates the
  symmetric-KL divergence. "JS" calculates the Jenson-Shannon distance. "TV"
  calculates the total variation distance.
}
\examples{
# Bring in small example data of single cell embeddings
data(example_SCE_small)
sample_id <- SingleCellExperiment::colData(example_SCE_small)$sample_id 
cluster_id <- SingleCellExperiment::colData(example_SCE_small)$cluster_id 
dist_result <- gloscopeProp(sample_id, cluster_id, ep = 0.5, 
                                   dist_metric = "KL")
dist_result
}
